/**
  ******************************************************************************
  * @file    py32t092_hal_msp.c
  * @author  MCU Application Team
  * @brief   This file provides code for the MSP Initialization
  *          and de-Initialization codes.
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2023 Puya Semiconductor Co.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by Puya under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2016 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */

/* Includes ------------------------------------------------------------------*/
#include "main.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* External functions --------------------------------------------------------*/

/**
  * @brief Initialize global MSP.
  */
void HAL_MspInit(void)
{
  __HAL_RCC_SYSCFG_CLK_ENABLE();
  __HAL_RCC_PWR_CLK_ENABLE();
}

/**
  * @brief Initialize I2S related MSP
  */
void HAL_I2S_MspInit(I2S_HandleTypeDef *hi2s)
{
  GPIO_InitTypeDef  GPIO_InitStruct = {0};
  /* Initialize SPI1 */
  if (hi2s->Instance == SPI1)
  {
    __HAL_RCC_GPIOA_CLK_ENABLE();                   /* Enable GPIOA clock */
    __HAL_RCC_GPIOB_CLK_ENABLE();                   /* Enable GPIOB clock */
    __HAL_RCC_SYSCFG_CLK_ENABLE();                  /* Enable SYSCFG clock */
    __HAL_RCC_SPI1_CLK_ENABLE();                    /* Enable SPI1 clock */
    __HAL_RCC_DMA_CLK_ENABLE();                     /* Enable DMA clock */
    
    /**I2S1 GPIO Configuration
      PB07 ------> I2S1_WS
      PA03 ------> I2S1_CK
      PA12 ------> I2S1_SD
    */
    /*CK/SD*/
    GPIO_InitStruct.Pin       = (GPIO_PIN_3 | GPIO_PIN_12);
    GPIO_InitStruct.Pull      = GPIO_NOPULL;
    GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
    GPIO_InitStruct.Speed     = GPIO_SPEED_FREQ_HIGH;
    GPIO_InitStruct.Alternate = GPIO_AF11_I2S1;
    HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);

    /*WS*/
    GPIO_InitStruct.Pin       = GPIO_PIN_7;
    GPIO_InitStruct.Pull      = GPIO_NOPULL;
    GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
    GPIO_InitStruct.Speed     = GPIO_SPEED_FREQ_HIGH;
    GPIO_InitStruct.Alternate = GPIO_AF6_I2S1;
    HAL_GPIO_Init(GPIOB, &GPIO_InitStruct);

    /* DMA_CH1 configuration */
    HdmaCh1.Instance                 = DMA_Channel1;
    HdmaCh1.Init.Direction           = DMA_MEMORY_TO_PERIPH;
    HdmaCh1.Init.PeriphInc           = DMA_PADDR_FIX;
    HdmaCh1.Init.MemInc              = DMA_MADDR_INC;
    HdmaCh1.Init.PeriphDataAlignment = DMA_PDATAALIGN_HALFWORD;
    HdmaCh1.Init.MemDataAlignment    = DMA_MDATAALIGN_HALFWORD;
    HdmaCh1.Init.Mode                = DMA_NORMAL;
    HdmaCh1.Init.Priority            = DMA_PRIORITY_0;
    HdmaCh1.Init.TransMode           = DMA_TRANSFER_SINGLE;
    /* DMA initialization */
    HAL_DMA_Init(&HdmaCh1);
    /* Associate the initialized DMA handle to the the I2S handle */
    __HAL_LINKDMA(hi2s, hdmatx, HdmaCh1);

    /* DMA_CH2 configuration */
    HdmaCh2.Instance                 = DMA_Channel2;
    HdmaCh2.Init.Direction           = DMA_PERIPH_TO_MEMORY;
    HdmaCh2.Init.PeriphInc           = DMA_PADDR_FIX;
    HdmaCh2.Init.MemInc              = DMA_MADDR_INC;
    HdmaCh2.Init.PeriphDataAlignment = DMA_PDATAALIGN_HALFWORD;
    HdmaCh2.Init.MemDataAlignment    = DMA_MDATAALIGN_HALFWORD;
    HdmaCh2.Init.Mode                = DMA_NORMAL;
    HdmaCh2.Init.Priority            = DMA_PRIORITY_1;
    HdmaCh2.Init.TransMode           = DMA_TRANSFER_SINGLE;
    /* DMA initialization */
    HAL_DMA_Init(&HdmaCh2);
    /* Associate the initialized DMA handle to the the I2S handle */
    __HAL_LINKDMA(hi2s, hdmarx, HdmaCh2);
  
    /* Set DMA request mapping */
    HAL_DMA_ChannelMap(&HdmaCh1, DMA_CHANNEL_MAP_SPI1_TX); /* I2S_SD:TX, DMA_CH1 */
    HAL_DMA_ChannelMap(&HdmaCh2, DMA_CHANNEL_MAP_SPI1_RX); /* I2S_SD:RX, DMA_CH2 */
  
    /* DMA interrupt settings */
    HAL_NVIC_SetPriority(DMA_Channel1_IRQn, 1, 0);
    HAL_NVIC_EnableIRQ(DMA_Channel1_IRQn);
    HAL_NVIC_SetPriority(DMA_Channel2_3_IRQn, 1, 0);
    HAL_NVIC_EnableIRQ(DMA_Channel2_3_IRQn);

    /* Interrupt configuration */
    HAL_NVIC_SetPriority(SPI1_IRQn, 1, 0);
    HAL_NVIC_EnableIRQ(SPI1_IRQn);
  }
}

/************************ (C) COPYRIGHT Puya *****END OF FILE******************/
