/**
  ******************************************************************************
  * @file    py32l090_hal_msp.c
  * @author  MCU Application Team
  * @brief   This file provides code for the MSP Initialization
  *          and de-Initialization codes.
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2023 Puya Semiconductor Co.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by Puya under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2016 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */

/* Includes ------------------------------------------------------------------*/
#include "main.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* External functions --------------------------------------------------------*/

/**
  * @brief Initialize global MSP.
  */
void HAL_MspInit(void)
{
  __HAL_RCC_SYSCFG_CLK_ENABLE();
  __HAL_RCC_PWR_CLK_ENABLE();
}

void HAL_UART_MspInit(UART_HandleTypeDef* UartHandle)
{
  GPIO_InitTypeDef GPIO_InitStruct = {0};
  if(UartHandle->Instance == UART1)
  {
    /* Peripheral clock enable */
    __HAL_RCC_UART1_CLK_ENABLE();
    /* DMA controller clock enable */
    __HAL_RCC_DMA_CLK_ENABLE();

    __HAL_RCC_GPIOB_CLK_ENABLE();
    
    /**UART1 GPIO Configuration
    PB8    ------> UART1_RX
    PB9    ------> UART1_TX
    */
    GPIO_InitStruct.Pin       = GPIO_PIN_8 | GPIO_PIN_9;
    GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
    GPIO_InitStruct.Pull      = GPIO_PULLUP;
    GPIO_InitStruct.Speed     = GPIO_SPEED_FREQ_LOW;
    GPIO_InitStruct.Alternate = GPIO_AF11_UART1;
    HAL_GPIO_Init(GPIOB, &GPIO_InitStruct);

    /* UART1 DMA Init */
    /* UART1_RX Init */
    hdma_uart_rx.Instance = DMA_Channel2;
    hdma_uart_rx.Init.Direction           = DMA_PERIPH_TO_MEMORY;
    hdma_uart_rx.Init.PeriphInc           = DMA_PADDR_FIX;
    hdma_uart_rx.Init.MemInc              = DMA_MADDR_INC;
    hdma_uart_rx.Init.PeriphDataAlignment = DMA_PDATAALIGN_BYTE;
    hdma_uart_rx.Init.MemDataAlignment    = DMA_MDATAALIGN_BYTE;
    hdma_uart_rx.Init.Mode                = DMA_NORMAL;
    hdma_uart_rx.Init.Priority            = DMA_PRIORITY_1;
    hdma_uart_rx.Init.TransMode           = DMA_TRANSFER_SINGLE;
    /* DMA initialization */
    if (HAL_DMA_Init(&hdma_uart_rx) != HAL_OK)
    {
      APP_ErrorHandler();
    }
    HAL_DMA_ChannelMap(&hdma_uart_rx, DMA_CHANNEL_MAP_UART1_RX);
    __HAL_LINKDMA(UartHandle, hdmarx, hdma_uart_rx);

    /* UART1_TX Init */
    hdma_uart_tx.Instance = DMA_Channel1;
    hdma_uart_tx.Init.Direction           = DMA_MEMORY_TO_PERIPH;
    hdma_uart_tx.Init.PeriphInc           = DMA_PADDR_FIX;
    hdma_uart_tx.Init.MemInc              = DMA_MADDR_INC;
    hdma_uart_tx.Init.PeriphDataAlignment = DMA_PDATAALIGN_BYTE;
    hdma_uart_tx.Init.MemDataAlignment    = DMA_MDATAALIGN_BYTE;
    hdma_uart_tx.Init.Mode                = DMA_NORMAL;
    hdma_uart_tx.Init.Priority            = DMA_PRIORITY_0;
    hdma_uart_tx.Init.TransMode           = DMA_TRANSFER_SINGLE;
    /* DMA initialization */
    if (HAL_DMA_Init(&hdma_uart_tx) != HAL_OK)
    {
      APP_ErrorHandler();
    }
    HAL_DMA_ChannelMap(&hdma_uart_tx, DMA_CHANNEL_MAP_UART1_TX);
    __HAL_LINKDMA(UartHandle, hdmatx, hdma_uart_tx);

    /* NVIC enable */
    HAL_NVIC_SetPriority(DMA_Channel1_IRQn, 1, 0);
    HAL_NVIC_EnableIRQ(DMA_Channel1_IRQn);
    HAL_NVIC_SetPriority(DMA_Channel2_3_IRQn, 1, 0);
    HAL_NVIC_EnableIRQ(DMA_Channel2_3_IRQn);
    
    /* UART1 interrupt Init */
    HAL_NVIC_SetPriority(UART1_LPUART1_IRQn, 1, 0);
    HAL_NVIC_EnableIRQ(UART1_LPUART1_IRQn);
  }
}

/************************ (C) COPYRIGHT Puya *****END OF FILE******************/
