/**
  ******************************************************************************
  * @file    usbd_customhid_if.c
  * @author  MCU Application Team
  * @brief   USB Device Custom HID interface file.
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2024 Puya Semiconductor Co.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by Puya under Ultimate Liberty license
  * SLA0044, the "License"; You may not use this file except in compliance with
  * the License. You may obtain a copy of the License at:
  *                      www.st.com/SLA0044
  *
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2015 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under Ultimate Liberty license
  * SLA0044, the "License"; You may not use this file except in compliance with
  * the License. You may obtain a copy of the License at:
  *                      www.st.com/SLA0044
  *
  ******************************************************************************
  */

/* Includes ------------------------------------------------------------------*/
#include "usbd_customhid_if.h"
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
static int8_t CUSTOM_HID_Init(void);
static int8_t CUSTOM_HID_DeInit(void);
static int8_t CUSTOM_HID_OutEvent(uint8_t event_idx, uint8_t state);

/* Private variables ---------------------------------------------------------*/
__ALIGN_BEGIN static uint8_t CUSTOM_HID_ReportDesc[USBD_CUSTOM_HID_REPORT_DESC_SIZE] __ALIGN_END =
{
  0x05, 0x01,        /* Usage Page (Generic Desktop Ctrls)                                                       */
  0x09, 0x02,        /* Usage (Mouse)                                                                            */
  0xA1, 0x01,        /* Collection (Application)                                                                 */
  0x09, 0x01,        /*   Usage (Pointer)                                                                        */
  0xA1, 0x00,        /*   Collection (Physical)                                                                  */
  0x05, 0x09,        /*     Usage Page (Button)                                                                  */
  0x19, 0x01,        /*     Usage Minimum (0x01)                                                                 */
  0x29, 0x03,        /*     Usage Maximum (0x03)                                                                 */
  0x15, 0x00,        /*     Logical Minimum (0)                                                                  */
  0x25, 0x01,        /*     Logical Maximum (1)                                                                  */
  0x95, 0x03,        /*     Report Count (3)                                                                     */
  0x75, 0x01,        /*     Report Size (1)                                                                      */
  0x81, 0x02,        /*     Input (Data,Var,Abs,No Wrap,Linear,Preferred State,No Null Position)                 */
  0x95, 0x01,        /*     Report Count (1)                                                                     */
  0x75, 0x05,        /*     Report Size (5)                                                                      */
  0x81, 0x01,        /*     Input (Const,Array,Abs,No Wrap,Linear,Preferred State,No Null Position)              */
  0x05, 0x01,        /*     Usage Page (Generic Desktop Ctrls)                                                   */
  0x09, 0x30,        /*     Usage (X)                                                                            */
  0x09, 0x31,        /*     Usage (Y)                                                                            */
  0x09, 0x38,        /*     Usage (Wheel)                                                                        */
  0x15, 0x81,        /*     Logical Minimum (-127)                                                               */
  0x25, 0x7F,        /*     Logical Maximum (127)                                                                */
  0x75, 0x08,        /*     Report Size (8)                                                                      */
  0x95, 0x03,        /*     Report Count (3)                                                                     */
  0x81, 0x06,        /*     Input (Data,Var,Rel,No Wrap,Linear,Preferred State,No Null Position)                 */
  0xC0,              /*   End Collection                                                                         */
  0x09, 0x3C,        /*   Usage (Motion Wakeup)                                                                  */
  0x05, 0xFF,        /*   Usage Page (Reserved 0xFF)                                                             */
  0x09, 0x01,        /*   Usage (0x01)                                                                           */
  0x15, 0x00,        /*   Logical Minimum (0)                                                                    */
  0x25, 0x01,        /*   Logical Maximum (1)                                                                    */
  0x75, 0x01,        /*   Report Size (1)                                                                        */
  0x95, 0x02,        /*   Report Count (2)                                                                       */
  0xB1, 0x22,        /*   Feature (Data,Var,Abs,No Wrap,Linear,No Preferred State,No Null Position,Non-volatile) */
  0x75, 0x06,        /*   Report Size (6)                                                                        */
  0x95, 0x01,        /*   Report Count (1)                                                                       */
  0xB1, 0x01,        /*   Feature (Const,Array,Abs,No Wrap,Linear,Preferred State,No Null Position,Non-volatile) */
  0xC0,              /* End Collection                                                                           */
}; 

USBD_CUSTOM_HID_ItfTypeDef USBD_CustomHID_fops =
{
  CUSTOM_HID_ReportDesc,
  CUSTOM_HID_Init,
  CUSTOM_HID_DeInit,
  CUSTOM_HID_OutEvent,
};

/* Private functions ---------------------------------------------------------*/

/**
  * @brief  CUSTOM_HID_Init
  *         Initializes the CUSTOM HID media low layer
  * @param  None
  * @retval Result of the operation: USBD_OK if all operations are OK else USBD_FAIL
  */
static int8_t CUSTOM_HID_Init(void)
{

  return (0);
}

/**
  * @brief  CUSTOM_HID_DeInit
  *         DeInitializes the CUSTOM HID media low layer
  * @param  None
  * @retval Result of the operation: USBD_OK if all operations are OK else USBD_FAIL
  */
static int8_t CUSTOM_HID_DeInit(void)
{
  /*
     Add your deinitialization code here
  */
  return (0);
}


/**
  * @brief  CUSTOM_HID_Control
  *         Manage the CUSTOM HID class events
  * @param  event_idx: event index
  * @param  state: event state
  * @retval Result of the operation: USBD_OK if all operations are OK else USBD_FAIL
  */
static int8_t CUSTOM_HID_OutEvent(uint8_t event_idx, uint8_t state)
{

  return (0);
}
/************************ (C) COPYRIGHT Puya *****END OF FILE******************/
