/**
  ******************************************************************************
  * @file    usart_common_interface.h
  * @author  MCD Application Team
  * @brief   Header for usart_common_interface.c module
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2023 Puya Semiconductor Co.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by Puya under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */

#ifndef USART_COMMON_INTERFACE_H
#define USART_COMMON_INTERFACE_H

#include "platform.h"

void USART_Init(USART_TypeDef * usart);
void USART_DeInit(USART_TypeDef * usart);
void USART_Read(USART_TypeDef * usart,uint8_t *buf, uint16_t size);
void USART_Write(USART_TypeDef * usart,uint8_t *buf, uint16_t size);
uint8_t USART_ProtocolDetection(USART_TypeDef * usart);

#endif /* USART_COMMON_INTERFACE_H */


