/**
  ******************************************************************************
  * @file    usart2_interface.c
  * @author  MCD Application Team
  * @brief   Contains USART HW configuration
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2023 Puya Semiconductor Co.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by Puya under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */

#include "iwdg_interface.h"
#include "wwdg_interface.h"
#include "usart_common_interface.h"
#include "openbl_usart_cmd.h"
#include "openbl_core.h"

//static SCI_HandleTypeDef USART_Handler = {0};

static void USART_LowLevelInit(void)
{
  /* Peripheral clock enable */
  SET_BIT(RCC->APBENR1, RCC_APBENR1_USART2EN);
  SET_BIT(RCC->IOPENR, RCC_IOPENR_GPIOBEN);
//  /**USART2 GPIO Configuration
//  PB12     ------> USART2_TX
//  PB13     ------> USART2_RX

//  */
  MODIFY_REG(GPIOB->MODER, (GPIO_MODER_MODE13 | GPIO_MODER_MODE12), (GPIO_MODER_MODE13_1 | GPIO_MODER_MODE12_1));     //10: 复用功能模式
  MODIFY_REG(GPIOB->AFR[1], (GPIO_AFRH_AFSEL13 | GPIO_AFRH_AFSEL12), (GPIO_AFRH_AFSEL13_1 | GPIO_AFRH_AFSEL12_1));    //0010:AF2 USART2_TX(PB12) USART2_RX(PB13)
  MODIFY_REG(GPIOB->OSPEEDR, (GPIO_OSPEEDR_OSPEED13 | GPIO_OSPEEDR_OSPEED12), (GPIO_OSPEEDR_OSPEED13_1 | GPIO_OSPEEDR_OSPEED12_1));
  MODIFY_REG(GPIOB->PUPDR, (GPIO_PUPDR_PUPD13 | GPIO_PUPDR_PUPD12), (GPIO_PUPDR_PUPD13_0 | GPIO_PUPDR_PUPD12_0));
}

static void OPENBL_USART_Init(void)
{
  OPENBL_WWDG_Refresh();
  OPENBL_IWDG_Refresh();

  USART_LowLevelInit();

  USART_Init(USART2);
}

static void OPENBL_USART_DeInit(void)
{
  USART_DeInit(USART2);
  RCC->APBENR1 &= ~(RCC_APBENR1_USART2EN);
  RCC->APBRSTR1 |= (RCC_APBRSTR1_USART2RST);
  RCC->APBRSTR1 &= ~(RCC_APBRSTR1_USART2RST);
  CLEAR_BIT(GPIOB->AFR[1], GPIO_AFRH_AFSEL13 | GPIO_AFRH_AFSEL12);
//  HAL_GPIO_DeInit(GPIOB ,GPIO_PIN_13 | GPIO_PIN_12);
}

static void OPENBL_USART_Read(uint8_t *buf, uint16_t size)
{
  USART_Read(USART2, buf, size);
}

static void OPENBL_USART_Write(uint8_t *buf, uint16_t size)
{
  USART_Write(USART2, buf, size);
}

static uint8_t OPENBL_USART_ProtocolDetection(void)
{
  return USART_ProtocolDetection(USART2);
}

static const OPENBL_OpsTypeDef USART_Ops =
{
  .Init = OPENBL_USART_Init,
  .DeInit = OPENBL_USART_DeInit,
  .Detection = OPENBL_USART_ProtocolDetection,
  .CommandProcess = OPENBL_USART_CommandProcess,
};

static const OPENBL_IOTypeDef USART_IO =
{
  .Read = OPENBL_USART_Read,
  .Write = OPENBL_USART_Write,
};

OPENBL_HandleTypeDef USART2_Handle =
{
  .p_Ops = &USART_Ops,
  .p_IO = &USART_IO,
};

/************************ (C) COPYRIGHT Puya *****END OF FILE****/
