/**
  ******************************************************************************
  * @file    usart1_interface.c
  * @author  MCD Application Team
  * @brief   Contains USART HW configuration
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2023 Puya Semiconductor Co.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by Puya under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */

#include "iwdg_interface.h"
#include "wwdg_interface.h"
#include "usart_common_interface.h"
#include "openbl_usart_cmd.h"
#include "openbl_core.h"

//static SCI_HandleTypeDef USART_Handler = {0};

//static USART_TypeDef *USART_Handler = USART1;
static void USART_LowLevelInit(void)
{
//  /* Peripheral clock enable */
  SET_BIT(RCC->APBENR2, RCC_APBENR2_USART1EN);
  SET_BIT(RCC->IOPENR, RCC_IOPENR_GPIODEN);
//  /**USART1 GPIO Configuration
//  PD2     ------> USART1_TX 
//  PD3     ------> USART1_RX 
//  */
  MODIFY_REG(GPIOD->MODER, (GPIO_MODER_MODE2 | GPIO_MODER_MODE3), (GPIO_MODER_MODE2_1 | GPIO_MODER_MODE3_1));     //10: 复用功能模式
  MODIFY_REG(GPIOD->AFR[0], GPIO_AFRL_AFSEL2, (GPIO_AFRL_AFSEL2_0 | GPIO_AFRL_AFSEL2_1));                        //0011:AF3 USART1_TX(PD2)
  MODIFY_REG(GPIOD->AFR[0], GPIO_AFRL_AFSEL3, GPIO_AFRL_AFSEL3_2);                                                //0100:AF4 USART1_TX(PD3)
  MODIFY_REG(GPIOD->OSPEEDR,(GPIO_OSPEEDR_OSPEED2|GPIO_OSPEEDR_OSPEED3),(GPIO_OSPEEDR_OSPEED2_1|GPIO_OSPEEDR_OSPEED3_1));
  MODIFY_REG(GPIOD->PUPDR,(GPIO_PUPDR_PUPD2|GPIO_PUPDR_PUPD3),(GPIO_PUPDR_PUPD2_0|GPIO_PUPDR_PUPD3_0));
}

static void OPENBL_USART_Init(void)
{
  OPENBL_WWDG_Refresh();
  OPENBL_IWDG_Refresh();

  USART_LowLevelInit();

  USART_Init(USART1);
}

static void OPENBL_USART_DeInit(void)
{
  
  USART_DeInit(USART1);
  RCC->APBENR2 &= ~(RCC_APBENR2_USART1EN);
  RCC->APBRSTR2 |= (RCC_APBRSTR2_USART1RST);
  RCC->APBRSTR2 &= ~(RCC_APBRSTR2_USART1RST);
  CLEAR_BIT(GPIOD->AFR[0],GPIO_AFRL_AFSEL2|GPIO_AFRL_AFSEL3);
//  MODIFY_REG(GPIOD->AFR[0], (GPIO_AFRH_AFSEL9 | GPIO_AFRH_AFSEL10_0), (GPIO_AFRH_AFSEL9_0 | GPIO_AFRH_AFSEL10_0));  //0001:AF1 USART1_TX(PA9) USART1_RX(PA10)
//  HAL_GPIO_DeInit(GPIOD ,GPIO_PIN_2 | GPIO_PIN_3);

}

static void OPENBL_USART_Read(uint8_t *buf, uint16_t size)
{
  USART_Read(USART1, buf, size);
}

static void OPENBL_USART_Write(uint8_t *buf, uint16_t size)
{
  USART_Write(USART1, buf, size);
}

static uint8_t OPENBL_USART_ProtocolDetection(void)
{
  return USART_ProtocolDetection(USART1);
}

static const OPENBL_OpsTypeDef USART_Ops =
{
  .Init = OPENBL_USART_Init,
  .DeInit = OPENBL_USART_DeInit,
  .Detection = OPENBL_USART_ProtocolDetection,
  .CommandProcess = OPENBL_USART_CommandProcess,
};

static const OPENBL_IOTypeDef USART_IO =
{
  .Read = OPENBL_USART_Read,
  .Write = OPENBL_USART_Write,
};

OPENBL_HandleTypeDef USART1_Handle =
{
  .p_Ops = &USART_Ops,
  .p_IO = &USART_IO,
};

/************************ (C) COPYRIGHT Puya *****END OF FILE****/
