/**
  ******************************************************************************
  * @file    flash.h
  * @author  Puya Application Team
  * @brief   Header for flash.c module
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2021 Puya Semiconductor.
  * All rights reserved.</center></h2>
  *
  *
  ******************************************************************************
  */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __FLASH_H
#define __FLASH_H

/* Includes ------------------------------------------------------------------*/
#include "py32f0xx.h"
/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
#define GPIO_PIN_0                 ((uint16_t)0x0001)  /* Pin 0 selected    */
#define GPIO_PIN_1                 ((uint16_t)0x0002)  /* Pin 1 selected    */
#define GPIO_PIN_2                 ((uint16_t)0x0004)  /* Pin 2 selected    */
#define GPIO_PIN_3                 ((uint16_t)0x0008)  /* Pin 3 selected    */
#define GPIO_PIN_4                 ((uint16_t)0x0010)  /* Pin 4 selected    */
#define GPIO_PIN_5                 ((uint16_t)0x0020)  /* Pin 5 selected    */
#define GPIO_PIN_6                 ((uint16_t)0x0040)  /* Pin 6 selected    */
#define GPIO_PIN_7                 ((uint16_t)0x0080)  /* Pin 7 selected    */
#define GPIO_PIN_8                 ((uint16_t)0x0100)  /* Pin 8 selected    */
#define GPIO_PIN_9                 ((uint16_t)0x0200)  /* Pin 9 selected    */
#define GPIO_PIN_10                ((uint16_t)0x0400)  /* Pin 10 selected   */
#define GPIO_PIN_11                ((uint16_t)0x0800)  /* Pin 11 selected   */
#define GPIO_PIN_12                ((uint16_t)0x1000)  /* Pin 12 selected   */
#define GPIO_PIN_13                ((uint16_t)0x2000)  /* Pin 13 selected   */
#define GPIO_PIN_14                ((uint16_t)0x4000)  /* Pin 14 selected   */
#define GPIO_PIN_15                ((uint16_t)0x8000)  /* Pin 15 selected   */
#define GPIO_PIN_All               ((uint16_t)0xFFFF)  /* All pins selected */

#define SYSTEM_BASE             (0x1FFF0000UL)
#define BID_BASE                (SYSTEM_BASE + 0x00000BFCUL)
#define OPTION_BASE             (0x1FFF0F80UL)
#define OPTR1_BASE              (OPTION_BASE + 0x00000000UL)
#define OPTR2_BASE              (OPTION_BASE + 0x00000004UL)
#define WRPR_BASE               (OPTION_BASE + 0x00000010UL)
#define PCROP0SR_BASE           (OPTION_BASE + 0x00000014UL)
#define PCROP0ER_BASE           (OPTION_BASE + 0x00000018UL)
#define DBGMCU_IDCODE           ((DBGMCU->IDCODE) & IDCODE_DEVID_MASK)//(0x1FFF0FF8UL)
#define IDCODE_DEVID_MASK       (0x00000FFFUL)

#define FLASH_OPTR1             0x1F55E0AA
#define FLASH_OPTR2             0xFFFD0002
#define FLASH_WRPR              0x0000FFFF
#define FLASH_PCROP0SR          0xFE0001FF
#define FLASH_PCROP0ER          0xFFFF0000
#define FLASHSIZE_BASE         (0x1FFFF1160UL)

#define STM32F0_FLASHSIZE_BASE  (0x1FFFF7CCUL)
#define STM32F1_FLASHSIZE_BASE  (0x1FFFF7E0UL)
#define ST_UID_BASE             (0x1FFFF7E8UL)
#define ST_OPTION_BASE          (0x1FFFF800UL)
#define ST_BID_BASE             (0x1FFFF7A6UL)

#define __HAL_FLASH_TIME_REG_SET(__EPPARA0__,__EPPARA1__,__EPPARA2__,__EPPARA3__,__EPPARA4__)           \
                                                        do {                                            \
                                                            FLASH->TS0  = (__EPPARA0__)&0xFF;           \
                                                            FLASH->TS1  = ((__EPPARA0__)>>16)&0x1FF;    \
                                                            FLASH->TS3  = ((__EPPARA0__)>>8)&0xFF;      \
                                                            FLASH->TS2P = (__EPPARA1__)&0xFF;           \
                                                            FLASH->TPS3 = ((__EPPARA1__)>>16)&0x7FF;    \
                                                            FLASH->PERTPE = (__EPPARA2__)&0x1FFFF;      \
                                                            FLASH->SMERTPE = (__EPPARA3__)&0x1FFFF;     \
                                                            FLASH->PRGTPE = (__EPPARA4__)&0xFFFF;       \
                                                            FLASH->PRETPE = ((__EPPARA4__)>>16)&0x3FFF; \
                                                         } while(0U)

/* Exported functions ------------------------------------------------------- */
ErrorStatus WriteFlash(uint32_t dwAddr, uint8_t* pucDataBuf, uint8_t ucDataLength);
ErrorStatus WriteOption(uint32_t dwAddr, uint8_t* pucDataBuf, uint8_t ucDataLength);
ErrorStatus MassErase(void);
ErrorStatus PageErase(uint16_t* pwDataBuf, uint8_t ucDataLength, uint8_t ucPageCount);
ErrorStatus SectorErase(uint16_t* pwDataBuf, uint8_t ucDataLength);

#endif /* __FLASH_H */

/************************ (C) COPYRIGHT Puya Semiconductor *****END OF FILE****/
