/**
  ******************************************************************************
  * @file    systemmemory_interface.c
  * @author  MCD Application Team
  * @brief   Contains System Memory access functions
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2023 Puya Semiconductor Co.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by Puya under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */

/* Includes ------------------------------------------------------------------*/
#include "platform.h"
#include "openbl_mem.h"
#include "common_interface.h"
#include "systemmemory_interface.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
OPENBL_MemoryTypeDef SYS_Descriptor =
{
  .StartAddress = SYS_START_ADDRESS,
  .EndAddress = SYS_END_ADDRESS,
  .Size = SYS_END_ADDRESS - SYS_START_ADDRESS,
  .Type = AREA_SYS,
  .Read = OPENBL_SYSTEM_Read,
  .Write = NULL,
  .EraseChip = NULL,
  .EraseBank = NULL,
  .EraseBlock = NULL,
  .EraseSector = NULL,
  .ErasePage = NULL,
  .JumpToAddress = NULL,
};


void OPENBL_SYSTEM_Read(uint32_t Address, uint8_t *Data, uint32_t DataLength)
{
  for(uint32_t i = 0; i < DataLength; i++)
  {
    *Data++ = (*(uint8_t *)(Address++));
  }
}

