/**
  ******************************************************************************
  * @file    spi_common_interface.h
  * @author  MCD Application Team
  * @brief   Header for i2c_common_interface.c module
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2023 Puya Semiconductor Co.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by Puya under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */

#ifndef SPI_COMMON_INTERFACE_H
#define SPI_COMMON_INTERFACE_H

#include "platform.h"

void SPI_Init(SPI_TypeDef * spix, SPI_HandleTypeDef* hspi);
void SPI_DeInit(SPI_HandleTypeDef* hspi);
void SPI_Read(SPI_HandleTypeDef* hspi, uint8_t* buf, uint16_t size);
void SPI_Write(SPI_HandleTypeDef* hspi, uint8_t* buf, uint16_t size);
uint8_t SPI_ProtocolDetection(SPI_HandleTypeDef* hspi);

#endif /* SPI_COMMON_INTERFACE_H */


