/**
  ******************************************************************************
  * @file    i2c_common_interface.h
  * @author  MCD Application Team
  * @brief   Header for i2c_common_interface.c module
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2023 Puya Semiconductor Co.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by Puya under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */

#ifndef I2C_COMMON_INTERFACE_H
#define I2C_COMMON_INTERFACE_H

#include "platform.h"

void I2C_Init(I2C_TypeDef * i2cx, I2C_HandleTypeDef* hi2c);
void I2C_DeInit(I2C_HandleTypeDef* hi2c);
void I2C_Read(I2C_HandleTypeDef* hi2c, uint8_t* buf, uint16_t size);
void I2C_Write(I2C_HandleTypeDef* hi2c, uint8_t* buf, uint16_t size);
uint8_t I2C_ProtocolDetection(I2C_HandleTypeDef* hi2c);

#endif /* I2C_COMMON_INTERFACE_H */


